<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%question}}`.
 */
class m251214_103858_create_question_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%question}}', [
            'id' => $this->primaryKey(),
            'survey_id' => $this->integer()->notNull(),
                'question_text' => $this->text()->notNull(),
                'type' => $this->string(20)->notNull()->defaultValue('text'),
                'order' => $this->integer()->defaultValue(0),
                'created_at' => $this->timestamp()->defaultExpression('CURRENT_TIMESTAMP'),
            ]);

            $this->addForeignKey(
            'fk-question-survey_id',
            '{{%question}}',       
            'survey_id',           
            '{{%survey}}',         
            'id',                  
            'CASCADE',           
            'CASCADE'              
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%question}}');
    }
}
