<?php

namespace app\models;

use Yii;
use yii\db\ActiveRecord;

class Answer extends ActiveRecord
{
    public static function tableName()
    {
        return '{{%answer}}';
    }

    public function rules()
    {
        return [
            [['user_id', 'question_id', 'answer_value'], 'required'],
            [['user_id', 'question_id'], 'integer'],
            [['answer_value'], 'string'],
            
            // [['user_id', 'question_id'], 'unique', 'targetAttribute' => ['user_id', 'question_id']],
        ];
    }

    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'user_id' => 'Пользователь',
            'question_id' => 'Вопрос',
            'answer_value' => 'Ответ',
            'created_at' => 'Дата ответа',
        ];
    }

    
    public function getUser()
    {
        return $this->hasOne(User::class, ['id' => 'user_id']);
    }

    public function getQuestion()
    {
        return $this->hasOne(Question::class, ['id' => 'question_id']);
    }
}