<?php

namespace app\models;

use Yii;
use yii\db\ActiveRecord;

class Survey extends ActiveRecord
{
    public static function tableName()
    {
        return '{{%survey}}';
    }

    public function rules()
    {
        return [
            [['title', 'start_date', 'end_date'], 'required'],
            [['description'], 'string'],
            [['start_date', 'end_date'], 'date', 'format' => 'php:Y-m-d'],
            ['end_date', 'compare', 'compareAttribute' => 'start_date', 'operator' => '>='],
            ['title', 'string', 'max' => 255],
            ['is_active', 'boolean'],
        ];
    }

    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'title' => 'Название опроса',
            'description' => 'Описание',
            'start_date' => 'Дата начала',
            'end_date' => 'Дата окончания',
            'is_active' => 'Активен',
            'created_at' => 'Создан',
        ];
    }

    public function isActive()
    {
        $now = date('Y-m-d');
        return $this->is_active && 
               $this->start_date <= $now && 
               $this->end_date >= $now;
    }
}