<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model app\models\Question */
/* @var $survey app\models\Survey */

$this->title = 'Добавить вопрос к опросу: ' . $survey->title;
$this->params['breadcrumbs'][] = ['label' => 'Опросы', 'url' => ['/survey/index']];
$this->params['breadcrumbs'][] = ['label' => $survey->title, 'url' => ['/survey/view', 'id' => $survey->id]];
$this->params['breadcrumbs'][] = ['label' => 'Вопросы', 'url' => ['index', 'survey_id' => $survey->id]];
$this->params['breadcrumbs'][] = 'Добавить';
?>
<div class="question-create">
    <h1><?= Html::encode($this->title) ?></h1>

    <?php $form = ActiveForm::begin([
        'fieldConfig' => [
            'template' => "{label}\n{input}\n{error}",
            'labelOptions' => ['class' => 'form-label'],
            'inputOptions' => ['class' => 'form-control'],
            'errorOptions' => ['class' => 'invalid-feedback'],
        ],
    ]); ?>

    <?= $form->field($model, 'question_text')->textarea(['rows' => 3]) ?>

    <?= $form->field($model, 'type')->dropDownList([
        app\models\Question::TYPE_TEXT => 'Текстовый ответ',
        app\models\Question::TYPE_SCALE => 'Оценка по шкале (1-5)',
        app\models\Question::TYPE_SINGLE_CHOICE => 'Выбор одного варианта',
    ], ['prompt' => 'Выберите тип вопроса']) ?>

    <?= $form->field($model, 'order')->input('number', [
        'min' => 1,
        'placeholder' => 'Автоматически'
    ]) ?>

    <div class="form-group mt-3">
        <?= Html::submitButton('Добавить', ['class' => 'btn btn-success']) ?>
        <?= Html::a('Отмена', ['index', 'survey_id' => $survey->id], ['class' => 'btn btn-secondary']) ?>
    </div>

    <?php ActiveForm::end(); ?>
</div>