<?php

use yii\helpers\Html;

$this->title = 'Панель администратора';
$this->params['breadcrumbs'] = [
    ['label' => 'Главная', 'url' => ['/site/index'], 'icon' => 'fas fa-home'],
    ['label' => 'Панель администратора', 'icon' => 'fas fa-tachometer-alt']
];
?>

<div class="admin-dashboard">
    
    <div class="card">
        <div class="card-header">
            <h1 style="display: flex; align-items: center; gap: 15px;">
                <i class="fas fa-tachometer-alt" style="font-size: 2rem;"></i>
                <span>Добро пожаловать, <?= Html::encode($user->name) ?>!</span>
            </h1>
        </div>
        <div class="card-body">
            <p style="font-size: 1.1rem; color: var(--gray); margin-bottom: 30px;">
                Управляйте опросами и анализируйте результаты сотрудников
            </p>
        </div>
    </div>

    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px; margin-bottom: 30px;">
        <div class="card" style="border-left: 5px solid var(--primary);">
            <div class="card-body">
                <div style="display: flex; align-items: center; gap: 20px;">
                    <div style="background: linear-gradient(135deg, var(--primary) 0%, rgba(67, 97, 238, 0.1) 100%); width: 60px; height: 60px; border-radius: var(--radius); display: flex; align-items: center; justify-content: center;">
                        <i class="fas fa-clipboard-list" style="font-size: 1.8rem; color: var(--primary);"></i>
                    </div>
                    <div>
                        <div style="font-size: 0.9rem; color: var(--gray); margin-bottom: 5px;">Всего опросов</div>
                        <div style="font-size: 2rem; font-weight: 700; color: var(--dark);"><?= $totalSurveys ?></div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card" style="border-left: 5px solid var(--success);">
            <div class="card-body">
                <div style="display: flex; align-items: center; gap: 20px;">
                    <div style="background: linear-gradient(135deg, var(--success) 0%, rgba(76, 201, 240, 0.1) 100%); width: 60px; height: 60px; border-radius: var(--radius); display: flex; align-items: center; justify-content: center;">
                        <i class="fas fa-clipboard-check" style="font-size: 1.8rem; color: var(--success);"></i>
                    </div>
                    <div>
                        <div style="font-size: 0.9rem; color: var(--gray); margin-bottom: 5px;">Активные опросы</div>
                        <div style="font-size: 2rem; font-weight: 700; color: var(--dark);"><?= $activeSurveys ?></div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card" style="border-left: 5px solid var(--info);">
            <div class="card-body">
                <div style="display: flex; align-items: center; gap: 20px;">
                    <div style="background: linear-gradient(135deg, var(--info) 0%, rgba(72, 149, 239, 0.1) 100%); width: 60px; height: 60px; border-radius: var(--radius); display: flex; align-items: center; justify-content: center;">
                        <i class="fas fa-users" style="font-size: 1.8rem; color: var(--info);"></i>
                    </div>
                    <div>
                        <div style="font-size: 0.9rem; color: var(--gray); margin-bottom: 5px;">Пользователи</div>
                        <div style="font-size: 2rem; font-weight: 700; color: var(--dark);"><?= $totalUsers ?></div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card" style="border-left: 5px solid var(--warning);">
            <div class="card-body">
                <div style="display: flex; align-items: center; gap: 20px;">
                    <div style="background: linear-gradient(135deg, var(--warning) 0%, rgba(248, 150, 30, 0.1) 100%); width: 60px; height: 60px; border-radius: var(--radius); display: flex; align-items: center; justify-content: center;">
                        <i class="fas fa-comment-dots" style="font-size: 1.8rem; color: var(--warning);"></i>
                    </div>
                    <div>
                        <div style="font-size: 0.9rem; color: var(--gray); margin-bottom: 5px;">Всего ответов</div>
                        <div style="font-size: 2rem; font-weight: 700; color: var(--dark);"><?= $totalAnswers ?></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    
    <div class="card">
        <div class="card-header">
            <h2 style="display: flex; align-items: center; gap: 10px;">
                <i class="fas fa-bolt" style="color: var(--warning);"></i>
                <span>Быстрые действия</span>
            </h2>
        </div>
        <div class="card-body">
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 20px;">
                <a href="<?= \yii\helpers\Url::to(['/survey/create']) ?>" class="card" style="text-decoration: none; color: inherit; background: linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%); border: 2px solid var(--success);">
                    <div class="card-body" style="text-align: center; padding: 25px 15px;">
                        <div style="margin-bottom: 15px;">
                            <i class="fas fa-plus-circle" style="font-size: 3rem; color: var(--success);"></i>
                        </div>
                        <h3 style="margin-bottom: 10px; color: var(--dark);">Создать опрос</h3>
                        <p style="color: var(--gray); font-size: 0.9rem;">Создайте новый опрос для сотрудников</p>
                    </div>
                </a>

                <a href="<?= \yii\helpers\Url::to(['/survey/index']) ?>" class="card" style="text-decoration: none; color: inherit; background: linear-gradient(135deg, #cce5ff 0%, #b8daff 100%); border: 2px solid var(--info);">
                    <div class="card-body" style="text-align: center; padding: 25px 15px;">
                        <div style="margin-bottom: 15px;">
                            <i class="fas fa-list-check" style="font-size: 3rem; color: var(--info);"></i>
                        </div>
                        <h3 style="margin-bottom: 10px; color: var(--dark);">Все опросы</h3>
                        <p style="color: var(--gray); font-size: 0.9rem;">Просмотр и управление всеми опросами</p>
                    </div>
                </a>

                <div class="card" style="background: linear-gradient(135deg, #e2e3e5 0%, #d6d8db 100%); border: 2px solid var(--gray);">
                    <div class="card-body" style="text-align: center; padding: 25px 15px;">
                        <div style="margin-bottom: 15px;">
                            <i class="fas fa-chart-line" style="font-size: 3rem; color: var(--gray);"></i>
                        </div>
                        <h3 style="margin-bottom: 10px; color: var(--dark);">Аналитика</h3>
                        <p style="color: var(--gray); font-size: 0.9rem;">Статистика и отчеты по опросам</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    
    <?php if (!empty($recentSurveys)): ?>
        <div class="card" style="margin-top: 30px;">
            <div class="card-header">
                <h2 style="display: flex; align-items: center; gap: 10px;">
                    <i class="fas fa-history" style="color: var(--primary);"></i>
                    <span>Последние опросы</span>
                </h2>
            </div>
            <div class="card-body">
                <div style="overflow-x: auto;">
                    <table style="width: 100%; border-collapse: collapse;">
                        <thead>
                            <tr style="background: var(--gray-light);">
                                <th style="padding: 15px; text-align: left; font-weight: 600; color: var(--dark);">Название</th>
                                <th style="padding: 15px; text-align: left; font-weight: 600; color: var(--dark);">Период</th>
                                <th style="padding: 15px; text-align: left; font-weight: 600; color: var(--dark);">Статус</th>
                                <th style="padding: 15px; text-align: left; font-weight: 600; color: var(--dark);">Действия</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($recentSurveys as $survey): ?>
                                <tr style="border-bottom: 1px solid var(--border); transition: background 0.3s ease;">
                                    <td style="padding: 15px;">
                                        <div style="font-weight: 600; margin-bottom: 5px; color: var(--dark);">
                                            <?= Html::encode($survey->title) ?>
                                        </div>
                                        <div style="font-size: 0.9rem; color: var(--gray);">
                                            <?= Html::encode(mb_substr($survey->description, 0, 60)) ?>...
                                        </div>
                                    </td>
                                    <td style="padding: 15px; color: var(--gray);">
                                        <?= Yii::$app->formatter->asDate($survey->start_date) ?> -<br>
                                        <?= Yii::$app->formatter->asDate($survey->end_date) ?>
                                    </td>
                                    <td style="padding: 15px;">
                                        <?php if ($survey->isActive()): ?>
                                            <span style="display: inline-flex; align-items: center; gap: 5px; background: rgba(76, 201, 240, 0.1); color: var(--success); padding: 5px 12px; border-radius: 20px; font-size: 0.85rem; font-weight: 600;">
                                                <i class="fas fa-circle" style="font-size: 0.6rem;"></i>
                                                Активен
                                            </span>
                                        <?php else: ?>
                                            <span style="display: inline-flex; align-items: center; gap: 5px; background: rgba(108, 117, 125, 0.1); color: var(--gray); padding: 5px 12px; border-radius: 20px; font-size: 0.85rem; font-weight: 600;">
                                                <i class="fas fa-circle" style="font-size: 0.6rem;"></i>
                                                Завершен
                                            </span>
                                        <?php endif; ?>
                                    </td>
                                    <td style="padding: 15px;">
                                        <div style="display: flex; gap: 8px;">
                                            <a href="<?= \yii\helpers\Url::to(['survey/view', 'id' => $survey->id]) ?>" class="btn" style="padding: 8px 12px; background: var(--primary); color: white;">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="<?= \yii\helpers\Url::to(['survey/results', 'id' => $survey->id]) ?>" class="btn" style="padding: 8px 12px; background: var(--success); color: white;">
                                                <i class="fas fa-chart-bar"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>

<style>
.admin-dashboard .card {
    margin-bottom: 25px;
}

.admin-dashboard table tbody tr:hover {
    background: rgba(67, 97, 238, 0.05);
}

.admin-dashboard .card[style*="text-decoration: none"]:hover {
    transform: translateY(-8px) !important;
    box-shadow: 0 15px 35px rgba(0,0,0,0.15) !important;
}
</style>