<?php

use yii\helpers\Html;

/* @var $this yii\web\View */
/* @var $user app\models\User */
/* @var $surveysWithStatus array */

$this->title = 'Мои опросы';
?>
<div class="site-index">
    <div class="jumbotron">
        <h1>Добро пожаловать, <?= Html::encode($user->name) ?>!</h1>
        <p class="lead">Система внутренних опросов сотрудников</p>
    </div>

    <div class="body-content">
        <?php if (empty($surveysWithStatus)): ?>
            <div class="alert alert-info">
                <h4 class="alert-heading">Нет доступных опросов</h4>
                <p>В данный момент нет активных опросов для прохождения.</p>
                <p>Новые опросы будут появляться здесь по мере их создания администрацией.</p>
            </div>
        <?php else: ?>
            <h3 class="mb-4">Доступные опросы</h3>
            
            <div class="row">
                <?php foreach ($surveysWithStatus as $item): 
                    $survey = $item['survey'];
                    $alreadyTaken = $item['alreadyTaken'];
                ?>
                    <div class="col-md-6 mb-4">
                        <div class="card h-100 <?= $alreadyTaken ? 'border-success' : 'border-primary' ?>">
                            <div class="card-header <?= $alreadyTaken ? 'bg-success text-white' : 'bg-primary text-white' ?>">
                                <h5 class="card-title mb-0">
                                    <?= Html::encode($survey->title) ?>
                                    <?php if ($alreadyTaken): ?>
                                        <span class="badge bg-light text-success float-end">✓ Пройден</span>
                                    <?php endif; ?>
                                </h5>
                            </div>
                            <div class="card-body">
                                <p class="card-text"><?= Html::encode(mb_substr($survey->description, 0, 150)) ?>...</p>
                                
                                <div class="mb-3">
                                    <small class="text-muted">
                                        <i class="bi bi-calendar"></i>
                                        <?= Yii::$app->formatter->asDate($survey->start_date) ?> - 
                                        <?= Yii::$app->formatter->asDate($survey->end_date) ?>
                                    </small>
                                </div>
                                
                                <div class="mt-auto">
                                    <?php if (!$alreadyTaken): ?>
                                        <?= Html::a('Пройти опрос', ['/survey/take', 'id' => $survey->id], 
                                            ['class' => 'btn btn-success']) ?>
                                    <?php else: ?>
                                        <button class="btn btn-outline-success" disabled>
                                            <i class="bi bi-check-circle"></i> Уже пройден
                                        </button>
                                    <?php endif; ?>
                                    
                                    <?= Html::a('Подробнее', ['/survey/view', 'id' => $survey->id], 
                                        ['class' => 'btn btn-outline-primary ms-2']) ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            
            <div class="alert alert-info mt-4">
                <h5 class="alert-heading">Информация</h5>
                <p class="mb-0">
                    Каждый опрос можно пройти только один раз. После отправки ответов изменить их будет невозможно.
                </p>
            </div>
        <?php endif; ?>
    </div>
</div>