<?php

use yii\helpers\Html;

$this->title = 'Employee Survey';


$isGuest = Yii::$app->user->isGuest;


if (!$isGuest) {
    $user = Yii::$app->user->identity;
    $role = $user->role === 'admin' ? 'Администратор' : 'Сотрудник';
}
?>

<div class="landing-page">
    
    <section class="hero-section" style="background: linear-gradient(135deg, #4361ee 0%, #3a0ca3 100%); color: white; padding: 100px 0; text-align: center; margin-top: -40px;">
        <div class="container">
            <div style="max-width: 800px; margin: 0 auto;">
                <i class="fas fa-clipboard-check" style="font-size: 5rem; margin-bottom: 30px;"></i>
                <h1 style="font-size: 3.5rem; margin-bottom: 20px; font-weight: 800;">
                    Employee Survey 
                </h1>
                
                <?php if ($isGuest): ?>
                    <p style="font-size: 1.3rem; margin-bottom: 40px; opacity: 0.9;">
                        Система внутренних опросов сотрудников<br>
                        Узнайте мнение команды и улучшите рабочие процессы
                    </p>
                    <div style="display: flex; gap: 20px; justify-content: center; flex-wrap: wrap;">
                        <a href="<?= \yii\helpers\Url::to(['/site/register']) ?>" 
                           class="btn" 
                           style="background: white; color: #4361ee; padding: 18px 40px; font-size: 1.2rem; font-weight: 600; border-radius: 50px;">
                            <i class="fas fa-rocket"></i>
                            Начать бесплатно
                        </a>
                        <a href="<?= \yii\helpers\Url::to(['/site/login']) ?>" 
                           class="btn" 
                           style="background: transparent; border: 3px solid white; color: white; padding: 18px 40px; font-size: 1.2rem; font-weight: 600; border-radius: 50px;">
                            <i class="fas fa-sign-in-alt"></i>
                            Войти в систему
                        </a>
                    </div>
                <?php else: ?>
                    <div style="background: rgba(255, 255, 255, 0.1); padding: 30px; border-radius: 20px; margin-bottom: 40px; backdrop-filter: blur(10px); border: 1px solid rgba(255, 255, 255, 0.2);">
                        <h2 style="font-size: 2.2rem; margin-bottom: 15px; color: white;">
                            Добро пожаловать, <strong><?= Html::encode($user->name) ?></strong>!
                        </h2>
                        <div style="display: inline-flex; align-items: center; gap: 10px; padding: 12px 25px; background: rgba(255, 255, 255, 0.15); border-radius: 50px; margin-bottom: 20px;">
                            <i class="fas fa-user-tag" style="font-size: 1.2rem;"></i>
                            <span style="font-size: 1.2rem; font-weight: 600;"><?= $role ?></span>
                        </div>
                        
                        <div style="display: flex; gap: 20px; justify-content: center; flex-wrap: wrap; margin-top: 30px;">
                            <?php if ($user->role === 'admin'): ?>
                                <p style="font-size: 1.3rem; margin-bottom: 20px; width: 100%;">
                                    Вы можете создавать опросы и просматривать результаты.
                                </p>
                                <a href="<?= \yii\helpers\Url::to(['/survey/index']) ?>" 
                                   class="btn" 
                                   style="background: white; color: #4361ee; padding: 18px 40px; font-size: 1.2rem; font-weight: 600; border-radius: 50px;">
                                    <i class="fas fa-list-check"></i>
                                    Управление опросами
                                </a>
                            <?php else: ?>
                                <p style="font-size: 1.3rem; margin-bottom: 20px; width: 100%;">
                                    Вы можете проходить доступные опросы.
                                </p>
                                <a href="<?= \yii\helpers\Url::to(['/survey/index']) ?>" 
                                   class="btn" 
                                   style="background: white; color: #4361ee; padding: 18px 40px; font-size: 1.2rem; font-weight: 600; border-radius: 50px;">
                                    <i class="fas fa-clipboard-question"></i>
                                    Смотреть опросы
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>

    <section style="padding: 80px 0; background: white;">
        <div class="container">
            <div style="text-align: center; margin-bottom: 60px;">
                <h2 style="font-size: 2.5rem; color: #2b2d42; margin-bottom: 20px;">
                    Почему выбирают нашу платформу?
                </h2>
                <p style="font-size: 1.2rem; color: #6c757d; max-width: 700px; margin: 0 auto;">
                    Мы создали идеальное решение для сбора и анализа обратной связи
                </p>
            </div>

            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 30px;">
                <div class="feature-card" style="background: white; padding: 40px 30px; border-radius: 15px; text-align: center; box-shadow: 0 10px 30px rgba(0,0,0,0.1); transition: transform 0.3s ease; border: 2px solid #e9ecef;">
                    <div style="background: linear-gradient(135deg, #4cc9f0 0%, #38b2e0 100%); width: 80px; height: 80px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto 25px;">
                        <i class="fas fa-shield-alt" style="font-size: 2.5rem; color: white;"></i>
                    </div>
                    <h3 style="color: #2b2d42; margin-bottom: 15px; font-size: 1.5rem;">Анонимность</h3>
                    <p style="color: #6c757d; line-height: 1.6;">
                        Ответы сотрудников полностью анонимны. Это гарантирует честность и открытость обратной связи.
                    </p>
                </div>

                <div class="feature-card" style="background: white; padding: 40px 30px; border-radius: 15px; text-align: center; box-shadow: 0 10px 30px rgba(0,0,0,0.1); transition: transform 0.3s ease; border: 2px solid #e9ecef;">
                    <div style="background: linear-gradient(135deg, #f72585 0%, #e11570 100%); width: 80px; height: 80px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto 25px;">
                        <i class="fas fa-chart-line" style="font-size: 2.5rem; color: white;"></i>
                    </div>
                    <h3 style="color: #2b2d42; margin-bottom: 15px; font-size: 1.5rem;">Аналитика</h3>
                    <p style="color: #6c757d; line-height: 1.6;">
                        Детальная статистика и графики для анализа результатов. Экспорт данных в различных форматах.
                    </p>
                </div>

                <div class="feature-card" style="background: white; padding: 40px 30px; border-radius: 15px; text-align: center; box-shadow: 0 10px 30px rgba(0,0,0,0.1); transition: transform 0.3s ease; border: 2px solid #e9ecef;">
                    <div style="background: linear-gradient(135deg, #7209b7 0%, #5a078f 100%); width: 80px; height: 80px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto 25px;">
                        <i class="fas fa-cogs" style="font-size: 2.5rem; color: white;"></i>
                    </div>
                    <h3 style="color: #2b2d42; margin-bottom: 15px; font-size: 1.5rem;">Гибкость</h3>
                    <p style="color: #6c757d; line-height: 1.6;">
                        Различные типы вопросов: шкалы, выбор вариантов, текстовые ответы. Настраивайте опросы под свои нужды.
                    </p>
                </div>
            </div>
        </div>
    </section>

    
    <section style="padding: 80px 0; background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);">
        <div class="container">
            <div style="text-align: center; margin-bottom: 60px;">
                <h2 style="font-size: 2.5rem; color: #2b2d42; margin-bottom: 20px;">
                    Как это работает?
                </h2>
                <p style="font-size: 1.2rem; color: #6c757d; max-width: 700px; margin: 0 auto;">
                    Простой процесс от создания опроса до анализа результатов
                </p>
            </div>

            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 40px; position: relative;">
               
                <div style="position: absolute; top: 60px; left: 0; right: 0; height: 3px; background: #4361ee; opacity: 0.2; z-index: 1;"></div>
                
                <div style="position: relative; z-index: 2; text-align: center;">
                    <div style="background: #4361ee; color: white; width: 120px; height: 120px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto 25px; font-size: 2.5rem; font-weight: bold; border: 8px solid white; box-shadow: 0 10px 30px rgba(0,0,0,0.1);">
                        1
                    </div>
                    <h3 style="color: #2b2d42; margin-bottom: 15px; font-size: 1.3rem;">Создание опроса</h3>
                    <p style="color: #6c757d;">
                        Администратор создает опрос с вопросами разных типов
                    </p>
                </div>

                <div style="position: relative; z-index: 2; text-align: center;">
                    <div style="background: #4CAF50; color: white; width: 120px; height: 120px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto 25px; font-size: 2.5rem; font-weight: bold; border: 8px solid white; box-shadow: 0 10px 30px rgba(0,0,0,0.1);">
                        2
                    </div>
                    <h3 style="color: #2b2d42; margin-bottom: 15px; font-size: 1.3rem;">Прохождение</h3>
                    <p style="color: #6c757d;">
                        Сотрудники анонимно отвечают на вопросы опроса
                    </p>
                </div>

                <div style="position: relative; z-index: 2; text-align: center;">
                    <div style="background: #FF9800; color: white; width: 120px; height: 120px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto 25px; font-size: 2.5rem; font-weight: bold; border: 8px solid white; box-shadow: 0 10px 30px rgba(0,0,0,0.1);">
                        3
                    </div>
                    <h3 style="color: #2b2d42; margin-bottom: 15px; font-size: 1.3rem;">Сбор данных</h3>
                    <p style="color: #6c757d;">
                        Система автоматически собирает и хранит все ответы
                    </p>
                </div>

                <div style="position: relative; z-index: 2; text-align: center;">
                    <div style="background: #f44336; color: white; width: 120px; height: 120px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto 25px; font-size: 2.5rem; font-weight: bold; border: 8px solid white; box-shadow: 0 10px 30px rgba(0,0,0,0.1);">
                        4
                    </div>
                    <h3 style="color: #2b2d42; margin-bottom: 15px; font-size: 1.3rem;">Анализ</h3>
                    <p style="color: #6c757d;">
                        Администратор анализирует результаты и принимает решения
                    </p>
                </div>
            </div>
        </div>
    </section>

    <section style="padding: 80px 0; background: white;">
        <div class="container">
            <div style="text-align: center; margin-bottom: 60px;">
                <h2 style="font-size: 2.5rem; color: #2b2d42; margin-bottom: 20px;">
                    Наши показатели
                </h2>
                <p style="font-size: 1.2rem; color: #6c757d; max-width: 700px; margin: 0 auto;">
                    Платформа, которой доверяют компании
                </p>
            </div>

            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 30px; text-align: center;">
                <div class="stat-card" style="padding: 30px; border: 2px solid #e9ecef; border-radius: 15px;">
                    <div style="font-size: 3rem; font-weight: 800; color: #4361ee; margin-bottom: 10px;">
                        100%
                    </div>
                    <div style="font-size: 1.1rem; color: #2b2d42; font-weight: 600;">
                        Анонимность
                    </div>
                </div>

                <div class="stat-card" style="padding: 30px; border: 2px solid #e9ecef; border-radius: 15px;">
                    <div style="font-size: 3rem; font-weight: 800; color: #4CAF50; margin-bottom: 10px;">
                        24/7
                    </div>
                    <div style="font-size: 1.1rem; color: #2b2d42; font-weight: 600;">
                        Доступность
                    </div>
                </div>

                <div class="stat-card" style="padding: 30px; border: 2px solid #e9ecef; border-radius: 15px;">
                    <div style="font-size: 3rem; font-weight: 800; color: #FF9800; margin-bottom: 10px;">
                        99.9%
                    </div>
                    <div style="font-size: 1.1rem; color: #2b2d42; font-weight: 600;">
                        Надежность
                    </div>
                </div>

                <div class="stat-card" style="padding: 30px; border: 2px solid #e9ecef; border-radius: 15px;">
                    <div style="font-size: 3rem; font-weight: 800; color: #f44336; margin-bottom: 10px;">
                        0₽
                    </div>
                    <div style="font-size: 1.1rem; color: #2b2d42; font-weight: 600;">
                        Бесплатно
                    </div>
                </div>
            </div>
        </div>
    </section>

    
    <section style="padding: 100px 0; background: linear-gradient(135deg, #2b2d42 0%, #1a1c2f 100%); color: white; text-align: center;">
        <div class="container">
            <div style="max-width: 700px; margin: 0 auto;">
                <h2 style="font-size: 2.8rem; margin-bottom: 25px;">
                    <?php if ($isGuest): ?>
                        Готовы улучшить работу своей компании?
                    <?php else: ?>
                        Начните работу прямо сейчас!
                    <?php endif; ?>
                </h2>
                <p style="font-size: 1.3rem; margin-bottom: 40px; opacity: 0.9;">
                    <?php if ($isGuest): ?>
                        Начните собирать честную обратную связь от сотрудников уже сегодня.<br>
                        Это бесплатно и займет всего несколько минут.
                    <?php else: ?>
                        Используйте все возможности платформы для эффективного сбора и анализа обратной связи.
                    <?php endif; ?>
                </p>
                <div style="display: flex; gap: 20px; justify-content: center; flex-wrap: wrap;">
                    <?php if ($isGuest): ?>
                        <a href="<?= \yii\helpers\Url::to(['/site/register']) ?>" 
                           class="btn" 
                           style="background: #4361ee; color: white; padding: 20px 50px; font-size: 1.3rem; font-weight: 600; border-radius: 50px;">
                            <i class="fas fa-user-plus"></i>
                            Зарегистрироваться
                        </a>
                        <a href="<?= \yii\helpers\Url::to(['/site/login']) ?>" 
                           class="btn" 
                           style="background: transparent; border: 3px solid white; color: white; padding: 20px 50px; font-size: 1.3rem; font-weight: 600; border-radius: 50px;">
                            <i class="fas fa-sign-in-alt"></i>
                            Войти в аккаунт
                        </a>
                    <?php else: ?>
                        <a href="<?= \yii\helpers\Url::to(['/survey/index']) ?>" 
                           class="btn" 
                           style="background: #4361ee; color: white; padding: 20px 50px; font-size: 1.3rem; font-weight: 600; border-radius: 50px;">
                            <i class="fas fa-list-check"></i>
                            Управление опросами
                        </a>
                        <?php if (Yii::$app->user->identity->isAdmin()): ?>
                            <a href="<?= \yii\helpers\Url::to(['/survey/create']) ?>" 
                               class="btn" 
                               style="background: #4CAF50; color: white; padding: 20px 50px; font-size: 1.3rem; font-weight: 600; border-radius: 50px;">
                                <i class="fas fa-plus-circle"></i>
                                Создать опрос
                            </a>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>
</div>

<style>
.landing-page .hero-section {
    animation: fadeIn 1s ease;
}

.landing-page .feature-card:hover {
    transform: translateY(-10px);
    border-color: #4361ee !important;
    box-shadow: 0 20px 40px rgba(67, 97, 238, 0.2) !important;
}

.landing-page .stat-card {
    transition: all 0.3s ease;
}

.landing-page .stat-card:hover {
    border-color: #4361ee !important;
    background: rgba(67, 97, 238, 0.05);
    transform: translateY(-5px);
}

@keyframes fadeIn {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

@media (max-width: 768px) {
    .landing-page .hero-section h1 {
        font-size: 2.5rem;
    }
    
    .landing-page .hero-section p {
        font-size: 1.1rem;
    }
    
    .landing-page section {
        padding: 50px 0;
    }
    
    .landing-page h2 {
        font-size: 2rem !important;
    }
    
    .landing-page .btn {
        padding: 15px 30px !important;
        font-size: 1.1rem !important;
    }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    
    const observerOptions = {
        threshold: 0.1,
        rootMargin: '0px 0px -50px 0px'
    };

    const observer = new IntersectionObserver(function(entries) {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.style.animation = 'fadeIn 0.8s ease forwards';
                observer.unobserve(entry.target);
            }
        });
    }, observerOptions);

    
    document.querySelectorAll('.feature-card, .stat-card').forEach(card => {
        card.style.opacity = '0';
        observer.observe(card);
    });
});
</script>