<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model app\models\User */

$this->title = 'Регистрация';
?>
<div class="site-register">
    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h1 class="h3 mb-0"><?= Html::encode($this->title) ?></h1>
                </div>
                <div class="card-body">
                    <?php $form = ActiveForm::begin(); ?>

                    <?= $form->field($model, 'name')->textInput(['autofocus' => true]) ?>

                    <?= $form->field($model, 'email')->textInput() ?>

                    <?= $form->field($model, 'password_hash')->passwordInput()->label('Пароль') ?>

                    <?= $form->field($model, 'role')->dropDownList([
                        'employee' => 'Сотрудник',
                        'admin' => 'Администратор'
                    ]) ?>

                    <div class="form-group">
                        <?= Html::submitButton('Зарегистрироваться', ['class' => 'btn btn-primary btn-block']) ?>
                    </div>

                    <?php ActiveForm::end(); ?>

                    <div class="text-center mt-3">
                        <p>Уже есть аккаунт? <?= Html::a('Войти', ['site/login']) ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>