<?php

use yii\helpers\Html;
use yii\helpers\Url;

/* @var $this yii\web\View */
/* @var $surveys app\models\Survey[] */
/* @var $user app\models\User */

$this->title = 'Опросы';
?>
<div class="survey-index">
    <h1><?= Html::encode($this->title) ?></h1>

    <?php if ($user->isAdmin()): ?>
        <p>
            <?= Html::a('Создать новый опрос', ['create'], ['class' => 'btn btn-success']) ?>
        </p>
    <?php endif; ?>

    <?php if (empty($surveys)): ?>
        <div class="alert alert-info">
            <?php if ($user->isAdmin()): ?>
                Нет созданных опросов. Создайте первый опрос!
            <?php else: ?>
                В данный момент нет доступных опросов.
            <?php endif; ?>
        </div>
    <?php else: ?>
        <div class="row">
            <?php foreach ($surveys as $survey): ?>
                <div class="col-md-6 mb-4">
                    <div class="card h-100">
                        <div class="card-body">
                            <h5 class="card-title"><?= Html::encode($survey->title) ?></h5>
                            <p class="card-text"><?= Html::encode($survey->description) ?></p>
                            <p class="text-muted">
                                <small>
                                    Период: <?= Yii::$app->formatter->asDate($survey->start_date) ?> - 
                                    <?= Yii::$app->formatter->asDate($survey->end_date) ?>
                                </small>
                            </p>
                            
                            <div class="mt-3">
                                <?= Html::a('Подробнее', ['view', 'id' => $survey->id], ['class' => 'btn btn-primary']) ?>
                                
                                <?php if ($user->isAdmin()): ?>
                                    <?= Html::a('Изменить', ['update', 'id' => $survey->id], ['class' => 'btn btn-secondary']) ?>
                                    <?= Html::a('Удалить', ['delete', 'id' => $survey->id], [
                                        'class' => 'btn btn-danger',
                                        'data' => [
                                            'confirm' => 'Вы уверены, что хотите удалить этот опрос?',
                                            'method' => 'post',
                                        ],
                                    ]) ?>
                                <?php elseif ($survey->isActive()): ?>
                                    <?= Html::a('Пройти опрос', ['view', 'id' => $survey->id], ['class' => 'btn btn-success']) ?>
                                <?php else: ?>
                                    <span class="badge bg-secondary">Неактивен</span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>
</div>