<?php

use yii\helpers\Html;
use yii\helpers\Url;

/* @var $this yii\web\View */
/* @var $survey app\models\Survey */
/* @var $questions app\models\Question[] */
/* @var $stats array */
/* @var $answersData array */

$this->title = 'Результаты: ' . $survey->title;

// ОТЛАДКА: Выводим информацию о данных
echo '<div style="display:none;">'; // Скрываем, но оставляем в коде для проверки
echo '<!-- Отладка данных -->';
echo '<!-- Количество вопросов: ' . count($questions) . ' -->';
foreach ($questions as $q) {
    echo '<!-- Вопрос ID ' . $q->id . ': ' . $q->question_text . ' -->';
    echo '<!-- Ответов на вопрос ' . $q->id . ': ' . ($stats[$q->id]['total'] ?? 0) . ' -->';
    if (isset($answersData[$q->id])) {
        echo '<!-- Данные ответов для вопроса ' . $q->id . ': ' . count($answersData[$q->id]) . ' ответов -->';
        foreach ($answersData[$q->id] as $answer) {
            echo '<!-- Ответ ID ' . $answer->id . ': ' . $answer->answer_value . ' -->';
        }
    }
}
echo '</div>';
?>
<div class="survey-results">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1><?= Html::encode($this->title) ?></h1>
        <div>
            <?= Html::a('Назад к опросу', ['view', 'id' => $survey->id], ['class' => 'btn btn-secondary']) ?>
        </div>
    </div>

    
    <div class="card mb-4">
        <div class="card-header">
            <h5 class="mb-0">Тестовая информация</h5>
        </div>
        <div class="card-body">
            <?php if (empty($questions)): ?>
                <p class="text-danger">В опросе нет вопросов!</p>
            <?php else: ?>
                <p>Всего вопросов: <?= count($questions) ?></p>
                
                <?php foreach ($questions as $index => $question): ?>
                    <div class="mb-3 p-3 border rounded">
                        <h6>Вопрос <?= $index + 1 ?>: <?= Html::encode($question->question_text) ?></h6>
                        <p>Тип: <?= $question->getTypeName() ?></p>
                        <p>Количество ответов: <?= $stats[$question->id]['total'] ?? 0 ?></p>
                        
                        <?php if (isset($answersData[$question->id]) && !empty($answersData[$question->id])): ?>
                            <p><strong>Ответы:</strong></p>
                            <div class="list-group">
                                <?php foreach ($answersData[$question->id] as $answer): ?>
                                    <div class="list-group-item">
                                        <div class="d-flex w-100 justify-content-between">
                                            <strong>
                                                <?= Html::encode($answer->user->name ?? 'Аноним') ?>:
                                            </strong>
                                            <small><?= Yii::$app->formatter->asDatetime($answer->created_at) ?></small>
                                        </div>
                                        <p class="mb-1 mt-2"><?= nl2br(Html::encode($answer->answer_value)) ?></p>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        <?php else: ?>
                            <p class="text-muted">Нет ответов на этот вопрос.</p>
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>
</div>