<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use app\models\Question;

/* @var $this yii\web\View */
/* @var $survey app\models\Survey */
/* @var $questions app\models\Question[] */
/* @var $user app\models\User */

$this->title = 'Пройти опрос: ' . $survey->title;
$this->params['breadcrumbs'][] = ['label' => 'Опросы', 'url' => ['index']];
$this->params['breadcrumbs'][] = ['label' => $survey->title, 'url' => ['view', 'id' => $survey->id]];
$this->params['breadcrumbs'][] = 'Пройти';
?>
<div class="survey-take">
    <h1><?= Html::encode($survey->title) ?></h1>
    
    <div class="alert alert-info mb-4">
        <p><strong>Описание:</strong> <?= Html::encode($survey->description) ?></p>
        <p><strong>Период проведения:</strong> 
            <?= Yii::$app->formatter->asDate($survey->start_date) ?> - 
            <?= Yii::$app->formatter->asDate($survey->end_date) ?>
        </p>
        <hr>
        <p class="mb-0">Пожалуйста, ответьте на все вопросы опроса. После отправки ответы нельзя будет изменить.</p>
    </div>
    
    <?php $form = ActiveForm::begin([
        'id' => 'survey-form',
        'fieldConfig' => [
            'template' => "{label}\n{input}\n{error}",
            'labelOptions' => ['class' => 'form-label fw-bold'],
            'errorOptions' => ['class' => 'invalid-feedback'],
        ],
    ]); ?>
    
    <?php foreach ($questions as $index => $question): ?>
        <div class="card mb-4">
            <div class="card-header bg-light">
                <h5 class="mb-0">
                    <span class="badge bg-primary"><?= $index + 1 ?></span>
                    <?= Html::encode($question->question_text) ?>
                </h5>
                <small class="text-muted"><?= $question->getTypeName() ?></small>
            </div>
            <div class="card-body">
                <?php if ($question->type === Question::TYPE_SCALE): ?>
                    <div class="form-group">
                        <p class="mb-2">Выберите оценку от 1 до 5:</p>
                        <div class="scale-options">
                            <?php for ($i = 1; $i <= 5; $i++): ?>
                                <div class="form-check form-check-inline">
                                    <?= Html::radio(
                                        "answers[{$question->id}]",
                                        false,
                                        [
                                            'value' => $i,
                                            'id' => "q{$question->id}_r{$i}",
                                            'class' => 'form-check-input',
                                            'required' => true
                                        ]
                                    ) ?>
                                    <?= Html::label($i, "q{$question->id}_r{$i}", ['class' => 'form-check-label']) ?>
                                </div>
                            <?php endfor; ?>
                        </div>
                        <div class="d-flex justify-content-between mt-1">
                            <small class="text-muted">1 - совсем не согласен</small>
                            <small class="text-muted">5 - полностью согласен</small>
                        </div>
                    </div>
                    
                <?php elseif ($question->type === Question::TYPE_SINGLE_CHOICE): ?>
                    <div class="form-group">
                        <div class="form-check mb-2">
                            <?= Html::radio(
                                "answers[{$question->id}]",
                                false,
                                [
                                    'value' => 'Да',
                                    'id' => "q{$question->id}_yes",
                                    'class' => 'form-check-input',
                                    'required' => true
                                ]
                            ) ?>
                            <?= Html::label('Да', "q{$question->id}_yes", ['class' => 'form-check-label']) ?>
                        </div>
                        <div class="form-check mb-2">
                            <?= Html::radio(
                                "answers[{$question->id}]",
                                false,
                                [
                                    'value' => 'Нет',
                                    'id' => "q{$question->id}_no",
                                    'class' => 'form-check-input',
                                    'required' => true
                                ]
                            ) ?>
                            <?= Html::label('Нет', "q{$question->id}_no", ['class' => 'form-check-label']) ?>
                        </div>
                        <div class="form-check">
                            <?= Html::radio(
                                "answers[{$question->id}]",
                                false,
                                [
                                    'value' => 'Затрудняюсь ответить',
                                    'id' => "q{$question->id}_notsure",
                                    'class' => 'form-check-input',
                                    'required' => true
                                ]
                            ) ?>
                            <?= Html::label('Затрудняюсь ответить', "q{$question->id}_notsure", ['class' => 'form-check-label']) ?>
                        </div>
                    </div>
                    
                <?php elseif ($question->type === Question::TYPE_TEXT): ?>
                    <div class="form-group">
                        <?= Html::textarea(
                            "answers[{$question->id}]",
                            '',
                            [
                                'class' => 'form-control',
                                'rows' => 4,
                                'placeholder' => 'Введите ваш ответ здесь...',
                                'required' => true
                            ]
                        ) ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    <?php endforeach; ?>
    
    <div class="card mb-4">
        <div class="card-body">
            <div class="alert alert-warning">
                <i class="bi bi-exclamation-triangle"></i>
                <strong>Внимание!</strong> После отправки ответы нельзя будет изменить.
            </div>
            
            <div class="form-group text-center">
                <?= Html::submitButton('Отправить ответы', [
                    'class' => 'btn btn-success btn-lg px-5',
                    'data' => [
                        'confirm' => 'Вы уверены, что хотите отправить ответы? После отправки изменить их будет невозможно.',
                    ]
                ]) ?>
                <?= Html::a('Отмена', ['view', 'id' => $survey->id], ['class' => 'btn btn-secondary btn-lg ms-3']) ?>
            </div>
        </div>
    </div>
    
    <?php ActiveForm::end(); ?>
</div>

<style>
.scale-options .form-check-inline {
    margin-right: 20px;
}
.scale-options .form-check-input {
    width: 1.2em;
    height: 1.2em;
}
</style>