<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $survey app\models\Survey */
/* @var $user app\models\User */

$this->title = $survey->title;
$this->params['breadcrumbs'][] = ['label' => 'Опросы', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="survey-view">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1><?= Html::encode($survey->title) ?></h1>
        
        <div>
            <?php if ($user->isAdmin()): ?>
                <div class="btn-group" role="group">
                    <?= Html::a('Управление вопросами', 
                        ['/question/index', 'survey_id' => $survey->id], 
                        ['class' => 'btn btn-info']) ?>
                    <?= Html::a('Результаты', ['results', 'id' => $survey->id], 
                        ['class' => 'btn btn-success']) ?>
                    <?= Html::a('Изменить', ['update', 'id' => $survey->id], 
                        ['class' => 'btn btn-primary']) ?>
                    <?= Html::a('Удалить', ['delete', 'id' => $survey->id], [
                        'class' => 'btn btn-danger',
                        'data' => [
                            'confirm' => 'Вы уверены, что хотите удалить этот опрос?',
                            'method' => 'post',
                        ],
                    ]) ?>
                </div>
            <?php endif; ?>
            
            <?= Html::a('Назад', ['index'], ['class' => 'btn btn-secondary']) ?>
        </div>
    </div>

    <?= DetailView::widget([
        'model' => $survey,
        'attributes' => [
            'description:text',
            [
                'attribute' => 'start_date',
                'format' => 'date',
                'label' => 'Дата начала',
            ],
            [
                'attribute' => 'end_date',
                'format' => 'date',
                'label' => 'Дата окончания',
            ],
            [
                'attribute' => 'is_active',
                'value' => function($model) {
                    return $model->is_active ? 'Да' : 'Нет';
                },
                'label' => 'Активен',
            ],
            [
                'attribute' => 'created_at',
                'format' => 'datetime',
                'label' => 'Создан',
            ],
        ],
    ]) ?>
    
    <?php if (!$user->isAdmin()): ?>
        <div class="card mt-4">
            <div class="card-body text-center">
                <?php
                
                $questions = \app\models\Question::find()
                    ->where(['survey_id' => $survey->id])
                    ->all();
                
                $alreadyTaken = false;
                if (!empty($questions)) {
                    $existingAnswer = \app\models\Answer::find()
                        ->where(['user_id' => $user->id])
                        ->andWhere(['question_id' => array_column($questions, 'id')])
                        ->exists();
                    $alreadyTaken = $existingAnswer;
                }
                ?>
                
                <?php if ($survey->isActive()): ?>
                    <?php if (!$alreadyTaken): ?>
                        <h4 class="card-title">Готовы пройти опрос?</h4>
                        <p class="card-text">Это займет всего несколько минут. Ваши ответы помогут улучшить работу компании.</p>
                        <?= Html::a('Начать опрос', ['take', 'id' => $survey->id], 
                            ['class' => 'btn btn-success btn-lg px-5']) ?>
                    <?php else: ?>
                        <h4 class="card-title text-success">✓ Вы уже прошли этот опрос</h4>
                        <p class="card-text">Спасибо за ваше участие! Ваши ответы были сохранены.</p>
                        <?php 
                        
                        $lastAnswer = \app\models\Answer::find()
                            ->where(['user_id' => $user->id])
                            ->andWhere(['question_id' => array_column($questions, 'id')])
                            ->orderBy(['created_at' => SORT_DESC])
                            ->one();
                        ?>
                        <?php if ($lastAnswer): ?>
                            <p class="text-muted">
                                <small>Пройден: <?= Yii::$app->formatter->asDatetime($lastAnswer->created_at) ?></small>
                            </p>
                        <?php endif; ?>
                    <?php endif; ?>
                <?php else: ?>
                    <h4 class="card-title text-muted">Опрос завершен</h4>
                    <p class="card-text">Прием ответов на этот опрос завершен.</p>
                    <?php if ($alreadyTaken): ?>
                        <p class="text-success">Вы участвовали в этом опросе.</p>
                    <?php else: ?>
                        <p class="text-warning">Вы не успели принять участие в этом опросе.</p>
                    <?php endif; ?>
                <?php endif; ?>
            </div>
        </div>
    <?php endif; ?>
    
    
    <?php
    $questions = \app\models\Question::find()
        ->where(['survey_id' => $survey->id])
        ->orderBy(['order' => SORT_ASC])
        ->all();
    ?>
    
    <?php if (!empty($questions)): ?>
        <div class="mt-5">
            <h3>Вопросы в опросе</h3>
            <div class="list-group mt-3">
                <?php foreach ($questions as $index => $question): ?>
                    <div class="list-group-item">
                        <div class="d-flex w-100 justify-content-between">
                            <h5 class="mb-1"><?= ($index + 1) ?>. <?= Html::encode($question->question_text) ?></h5>
                            <span class="badge bg-info"><?= $question->getTypeName() ?></span>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    <?php elseif ($user->isAdmin()): ?>
        <div class="alert alert-warning mt-4">
            <p>В этом опросе пока нет вопросов.</p>
            <p><?= Html::a('Добавить вопросы', 
                ['/question/index', 'survey_id' => $survey->id], 
                ['class' => 'btn btn-sm btn-warning']) ?></p>
        </div>
    <?php endif; ?>
</div>